<?php
//Template Name: Service
get_header();
$page_id = get_the_ID();
?>
 <div class="container-fluid page-header">
        <h1 class="display-3 text-uppercase text-white mb-3"><?php the_title();?></h1>
        <div class="d-inline-flex text-white">
            <h6 class="text-uppercase m-0"><a href="<?php echo site_url(); ?>">Home</a></h6>
            <h6 class="text-white m-0 px-3">/</h6>
            <h6 class="text-uppercase text-white m-0"><?php the_title();?></h6>
        </div>
    </div>
<?php $display_service = get_field('service_display',$page_id);
if($display_service==true){

?>
    <!-- Services Start -->
    <div class="container-fluid bg-light py-6 px-5">
        <div class="text-center mx-auto mb-5" style="max-width: 600px;">
            <h1 class="display-5 text-uppercase mb-4"><span class="text-primary"><?php echo get_field('service_heading',$page_id);?>  </span><?php echo get_field('service_heading_span',$page_id);?></h1>
        </div>
        <div class="row g-5">
             <?php
           $args = array(  
					'post_type' => 'Treatment',
					'post_status' => 'publish',
					'posts_per_page' => -1, 
					'orderby' => 'title', 
					'order' => 'ASC');
					$loop = new WP_Query( $args ); 
					while ( $loop->have_posts() ) : $loop->the_post(); 
					$featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'large');
					
					?>
             <div class="col-lg-4 col-md-6">
                <div class="service-item bg-white d-flex flex-column align-items-center text-center">
                    <img class="img-fluid" src="<?php echo $featured_img_url;?>" alt="">
                    <div class="service-icon bg-white">
                        <i class="fa fa-3x bi bi-clipboard-pulse text-primary"></i>
                    </div>
                    <div class="px-4 pb-4">
                        <h4 class="text-uppercase mb-3"><?php the_title(); ?></h4>
                        <p><?php the_field('service_content'); ?></p>
                       
                    </div>
                </div>
            </div>
               <?php 
				endwhile;
				wp_reset_postdata(); 
				?>
						
        </div>
    </div>
    <?php } ?>
<?php get_footer(); ?>