<?php
//Template Name: Gallery
$page_id = get_the_ID();
get_header();
?>
  <div class="container-fluid page-header">
        <h1 class="display-3 text-uppercase text-white mb-3"><?php the_title();?></h1>
        <div class="d-inline-flex text-white">
            <h6 class="text-uppercase m-0"><a href="<?php echo site_url(); ?>">Home</a></h6>
            <h6 class="text-white m-0 px-3">/</h6>
            <h6 class="text-uppercase text-white m-0"><?php the_title();?></h6>
        </div>
    </div>
    
   <?php $display_gallery = get_field('gallery_display',$page_id);
	if($display_gallery==true){
	?>

<div class="container-fluid bg-light py-6 px-5">
        <div class="text-center mx-auto mb-5" style="max-width: 600px;">
            
        </div>
        
        <div class="row g-5 portfolio-container">
            <?php
           $args = array(  
					'post_type' => 'Image',
					'post_status' => 'publish',
					'posts_per_page' => -1, 
					'orderby' => 'title', 
					'order' => 'DESC');
					$loop = new WP_Query( $args ); 
					while ( $loop->have_posts() ) : $loop->the_post(); 
					$featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'large');
					?>
            <div class="col-xl-4 col-lg-6 col-md-6 portfolio-item first">
                <div class="position-relative portfolio-box">
                    <img class="img-fluid w-100" src="<?php echo $featured_img_url;?>" alt="<?php echo $image_alt; ?>">
                   
                    <a class="portfolio-btn" href="<?php echo $featured_img_url;?>" data-lightbox="portfolio">
                        <i class="bi bi-plus text-white"></i>
                    </a>
                </div>
            </div>
                       <?php 
				endwhile;
				wp_reset_postdata(); 
				?>
            
        </div>
    </div>
    <?php } ?>
   
<?php get_footer();?>

  
