<?php
//Template Name: About
get_header();
$page_id = get_the_ID();
?>
 <div class="container-fluid page-header">
        <h1 class="display-3 text-uppercase text-white mb-3"><?php the_title();?></h1>
        <div class="d-inline-flex text-white">
            <h6 class="text-uppercase m-0"><a href="<?php echo site_url(); ?>">Home</a></h6>
            <h6 class="text-white m-0 px-3">/</h6>
            <h6 class="text-uppercase text-white m-0"><?php the_title();?></h6>
        </div>
    </div>

<?php $display_about = get_field('about_display',$page_id);
if($display_about==true){
	$image = get_field('about_image',$page_id);
?>
    <div class="container-fluid py-6 px-5">
        <div class="row g-5">
            <div class="col-lg-7">
                <h1 class="display-5 text-uppercase mb-4"><?php echo get_field('about_heading',$page_id);?> <span class="text-primary"><?php echo get_field('about_heading_span',$page_id);?></span> <br></h1>
                <h4 class="text-uppercase mb-3 text-body"><?php echo get_field('about_subheading',$page_id);?></h4>
                <p><?php echo get_field('about_content',$page_id);?>


</p>

<br><br>
<h5><?php echo get_field('education_heading',$page_id);?></h5>
<p><?php echo get_field('education_content',$page_id);?>

</p>
<h5><?php echo get_field('presentation',$page_id);?></h5>
<p>
  <?php echo get_field('presentation_content',$page_id);?>

</p>

<h5><?php echo get_field('publication',$page_id);?></h5>
<p>
  <?php echo get_field('publication_content',$page_id);?> 


</p>

<h5><?php echo get_field('attachements',$page_id);?></h5>
<p><?php echo get_field('attachment_content',$page_id);?>
 <br>
</p> <p class="mb-4">
</p>
           
            </div>
            <div class="col-lg-5 pb-5" style="min-height: 400px;">
                <div class="position-relative bg-dark-radial h-100 ms-5">
                    <img class="position-absolute w-100 h-100 mt-5 ms-n5" src="<?php echo $image['url'];?>" style="object-fit: contain;">
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<?php get_footer();?>