<?php get_header();?>
<!-- Carousel Start -->
<div class="container-fluid p-0">
        <div id="header-carousel" class="carousel slide carousel-fade" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php $args = array(  
					'post_type' => 'Banner',
					'post_status' => 'publish',
					'posts_per_page' => -1, 
					'orderby' => 'title', 
					'order' => 'ASC');
					$loop = new WP_Query( $args ); 
                    $i=1;  
					while ( $loop->have_posts() ) : $loop->the_post(); 
					$featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'large');
					?>
                <div class="carousel-item <?php if($i==1){?>active<?php } ?>">
                    <img class="w-100" src="<?php echo $featured_img_url ; ?>" alt="Image">
                    <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                        <div class="p-3" style="max-width: 900px;">
                            <h1 class="display-2 text-uppercase text-white mb-md-4"><?php the_title(); ?></h1>
                            <a href="<?php the_field('button_link'); ?>" class="btn btn-primary py-md-3 px-md-5 mt-2"><?php the_field('button'); ?></a>
                        </div>
                    </div>
                </div>
                <?php 
				$i++;
				endwhile;
				wp_reset_postdata(); 
				?>

            <button class="carousel-control-prev" type="button" data-bs-target="#header-carousel"
                data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#header-carousel"
                data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
            </button>
        </div>
    </div>
    <!-- Carousel End -->

<?php $display_boat_tours = get_field('about_display',$page_id);
	if($display_boat_tours==true){
		$image = get_field('about_image',$page_id);
	?>
    <!-- About Start -->
    <div class="container-fluid py-6 px-5">
        <div class="row g-5">
            <div class="col-lg-7">
                <h1 class="display-5 text-uppercase mb-4"><?php echo get_field('about_heading',$page_id);?> <span class="text-primary"><?php echo get_field('about_heading_span',$page_id);?></span> <br></h1>
                <h4 class="text-uppercase mb-3 text-body"><?php echo get_field('about_subheading',$page_id);?></h4>
                <p><?php echo get_field('about_text',$page_id);?></p>     
                <p class="mb-4"></p>
            </div>
            <div class="col-lg-5 pb-5" style="min-height: 400px;">
                <div class="position-relative bg-dark-radial h-100 ms-5">
                    <img class="position-absolute w-100 h-100 mt-5 ms-n5" src="<?php echo $image['url']; ?>" style="object-fit: cover;">
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    <!-- About End -->
    
<?php $display_service = get_field('service_display',$page_id);
	if($display_service==true){
	?>
    <!-- Services Start -->
    <div class="container-fluid bg-light py-6 px-5">
        <div class="text-center mx-auto mb-5" style="max-width: 600px;">
            <h1 class="display-5 text-uppercase mb-4"><span class="text-primary"><?php echo get_field('service_heading',$page_id);?> </span><?php echo get_field('service_heading_span',$page_id);?></h1>
        </div>
        <div class="row g-5">
            <?php
           $args = array(  
					'post_type' => 'Treatment',
					'post_status' => 'publish',
					'posts_per_page' => 6, 
					'orderby' => 'title', 
					'order' => 'DESC');
					$loop = new WP_Query( $args ); 
					while ( $loop->have_posts() ) : $loop->the_post(); 
					$featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'large');
					?>
             <div class="col-lg-4 col-md-6">
                <div class="service-item bg-white d-flex flex-column align-items-center text-center">
                    
                    <img class="img-fluid" src="<?php echo $featured_img_url; ?>" alt="">
                    <div class="service-icon bg-white">
                        <i class="fa fa-3x bi bi-clipboard-pulse text-primary"></i>
                    </div>
                    <div class="px-4 pb-4">
                        <h4 class="text-uppercase mb-3"><?php echo the_title(); ?></h4>
                        <p><?php the_field('service_content'); ?></p>
                        <!--<a class="btn text-primary" href="#">Read More <i class="bi bi-arrow-right"></i></a>-->
                    </div>
                    
                </div>
            </div>
              <?php 
				endwhile;
				wp_reset_postdata(); 
				?>	
            
            
        </div>
    </div>
    <!-- Services End -->

<?php } ?>
    
<?php $display_gallery = get_field('gallery_display',$page_id);
	if($display_gallery==true){
	?>

    <!-- Portfolio Start -->
    <div class="container-fluid bg-light py-6 px-5">
        <div class="text-center mx-auto mb-5" style="max-width: 600px;">
            <h1 class="display-5 text-uppercase mb-4"><?php echo get_field('gallery_heading',$page_id);?> <span class="text-primary"><?php echo get_field('gallery_heading_span',$page_id);?></span></h1>
        </div>
        
        <div class="row g-5 portfolio-container">
            <?php
           $args = array(  
					'post_type' => 'Image',
					'post_status' => 'publish',
					'posts_per_page' => 6, 
					'orderby' => 'title', 
					'order' => 'DESC');
					$loop = new WP_Query( $args ); 
					while ( $loop->have_posts() ) : $loop->the_post(); 
					$featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'large');
					?>
            <div class="col-xl-4 col-lg-6 col-md-6 portfolio-item first">
                <div class="position-relative portfolio-box">
                    <img class="img-fluid w-100" src="<?php echo $featured_img_url;?>" alt="">
                   
                    <a class="portfolio-btn" href="<?php echo $featured_img_url;?>" data-lightbox="portfolio">
                        <i class="bi bi-plus text-white"></i>
                    </a>
                </div>
            </div>
           <?php 
				endwhile;
				wp_reset_postdata(); 
				?>
           
        </div>
    </div>
    <?php } ?>
    
    <?php $display_contact = get_field('contact_display',$page_id);
	if($display_contact==true){
	?>
<!-- Appointment Start -->
    <div class="container-fluid py-6 px-5">
        <div class="row gx-5">
            <div class="col-lg-4 mb-5 mb-lg-0">
                <div class="mb-4">
                    <h1 class="display-5 text-uppercase mb-4"><?php echo get_field('contact_heading',$page_id);?> <span class="text-primary"><?php echo get_field('gallery_heading_span',$page_id);?></span></h1>
                </div>
                <p class="mb-5"><?php echo get_field('contact_text',$page_id);?></p>
               
            </div>
            <div class="col-lg-8">
                <div class="bg-light text-center p-5">
                    <div>
                        <div class="row g-3">
                           
                            <?php echo do_shortcode('[contact-form-7 id="7" title="Contact form 1"]'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Appointment End -->
    
    <?php } ?>
    
    <?php $display_testimonial = get_field('testimonial_display',$page_id);
	if($display_testimonial==true){
	    	$image = get_field('testimonial_image_back',$page_id);
	?>
    <div class="container-fluid bg-light py-6 px-5">
        <div class="text-center mx-auto mb-5" style="max-width: 600px;">
            <h1 class="display-5 text-uppercase mb-4"><?php echo get_field('testimonial_heading',$page_id);?> <span class="text-primary"><?php echo get_field('testimonial_heading_span',$page_id);?></span><?php echo get_field('testimonial_heading_two',$page_id);?></h1>
        </div>
        <div class="row gx-0 align-items-center">
            
            
            <div class="col-xl-4 col-lg-5 d-none d-lg-block">
                <img class="img-fluid w-100 h-100" src="<?php echo $image['url'];?>">
            </div>
            <div class="col-xl-8 col-lg-7 col-md-12">
                <div class="testimonial bg-light">
                    <div class="owl-carousel testimonial-carousel">
                        <?php
           $args = array(  
					'post_type' => 'Testimonial',
					'post_status' => 'publish',
					'posts_per_page' => 6, 
					'orderby' => 'title', 
					'order' => 'DESC');
					$loop = new WP_Query( $args ); 
					while ( $loop->have_posts() ) : $loop->the_post(); 
					$featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'large');
					?>
                        <div class="row gx-4 align-items-center">
                            <div class="col-xl-4 col-lg-5 col-md-5">
                                <img class="img-fluid w-100 h-100 bg-light p-lg-3 mb-4 mb-md-0" src="<?php echo $featured_img_url;?>" alt="">
                            </div>
                            <div class="col-xl-8 col-lg-7 col-md-7">
                                <h4 class="text-uppercase mb-0"><?php echo the_title(); ?></h4>
                                
                                <p class="fs-5 mb-0"><i class="fa fa-2x fa-quote-left text-primary me-2"></i> <?php echo get_the_content(); ?> </p>
                            </div>
                        </div>
                        
                        <?php 
				endwhile;
				wp_reset_postdata(); 
				?>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    
    
    
    
    
    
    
    
    
	<?php get_footer();?>